///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Precompiled Header
#include "Stdafx.h"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	Camera export method.
 *	This method is called once for each exported camera.
 *	\param		camera		[in] a structure filled with current camera information.
 *	\return		true if success.
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
bool ZCBFormat::ExportCamera(const CameraDescriptor& camera)
{
	// Export common information
	ExportBasicInfo(&camera, &mCameras);

	// Save parameters
	mCameras
		.Store(camera.mOrthoCam)
		.Store(camera.mFOV)
		.Store(camera.mNearClip)
		.Store(camera.mFarClip)
		.Store(camera.mTDist)
		.Store(camera.mHLineDisplay)
		.Store(camera.mEnvNearRange)
		.Store(camera.mEnvFarRange)
		.Store(camera.mEnvDisplay)
		.Store(camera.mManualClip);

	return true;
}
